﻿#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>
#include <stack>
#include <queue>
#include <set>
#include <unordered_set>
#include <map>
#include <unordered_map>
#include <cassert>
#include <bitset>
#include <cmath>
#include <string>

#pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

using namespace std;

using ll = long long;
using ld = long double;

const int INT_INF = 2e9 + 10;
const ll LL_INF = 2e18 + 10;

const int MOD = 998244353;

template<typename T> istream& operator >> (istream& in, vector<T>& a) {
	for (auto& i : a) {
		in >> i;
	}
	return in;
}

int mult(int a, int b) {
	return (ll)a * b % MOD;
}

int sum(int a, int b) {
	if (a + b >= MOD) {
		return a + b - MOD;
	}
	return a + b;
}

int diff(int a, int b) {
	if (a < b) {
		return a - b + MOD;
	}
	return a - b;
}

int fast_pow(int a, int p) {
	if (p == 0) {
		return 1;
	}
	if (p % 2 == 0) {
		return fast_pow(mult(a, a), p / 2);
	}
	return mult(a, fast_pow(a, p - 1));
}

int inverse(int a) {
	return fast_pow(a, MOD - 2);
}

int divide(int a, int b) {
	return mult(a, inverse(b));
}

int main() {
	int t_num;
	cin >> t_num;
	while (t_num--) {
		int n, m;
		cin >> n >> m;
		int up = 0;
		int pref_sum = 0;
		for (int len = 1; len <= n; len++) {
			vector<int> dp(n);
			dp[0] = m;
			int window = m;
			for (int i = 1; i < n; i++) {
				if (i < len) {
					dp[i] = mult(dp[i - 1], m);
				}
				else {
					dp[i] = mult(window, m - 1);
					window = diff(window, dp[i - len]);
				}
				window = sum(window, dp[i]);
			}
			up = sum(up, mult(diff(dp[n - 1], pref_sum), len));
			pref_sum = dp[n - 1];
		}
		cout << divide(up, pref_sum) << '\n';
	}
}
